/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;

public class VWQuickSort {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private Object[] m_items = null;
    private int m_sortOrder = 0;

    public VWQuickSort(Object[] items, int order) {
        this.m_items = items;
        this.m_sortOrder = order;
    }

    public void setSortOrder(int order) {
        this.m_sortOrder = order;
    }

    public int getSortOrder() {
        return this.m_sortOrder;
    }

    public void sort(int lo, int hi) {
        if (this.m_items.length > 0 && lo < hi) {
            int mid = this.split(lo, hi);
            this.sort(lo, mid - 1);
            this.sort(mid + 1, hi);
        }
    }

    private int split(int lo, int hi) {
        int splitPoint = -1;
        try {
            Object item = this.m_items[lo];
            splitPoint = lo;
            block6: for (int i = lo + 1; i <= hi; ++i) {
                switch (this.m_sortOrder) {
                    case 0: {
                        if (this.compareTo(this.m_items[i], item) >= 0) continue block6;
                        this.swap(++splitPoint, i);
                        continue block6;
                    }
                    case 1: {
                        if (this.compareTo(this.m_items[i], item) <= 0) continue block6;
                        this.swap(++splitPoint, i);
                    }
                }
            }
            this.swap(lo, splitPoint);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return splitPoint;
    }

    protected int compareTo(Object obj1, Object obj2) {
        String name1 = null;
        String name2 = null;
        if (obj1 instanceof String && obj2 instanceof String) {
            name1 = (String)obj1;
            name2 = (String)obj2;
        } else if (obj1 instanceof IVWSortItem && obj2 instanceof IVWSortItem) {
            name1 = ((IVWSortItem)obj1).getName();
            name2 = ((IVWSortItem)obj2).getName();
        } else {
            name1 = VWQubbleSort.getName(obj1);
            name2 = VWQubbleSort.getName(obj2);
        }
        int nResult = VWStringUtils.compareIgnoreCase(name1, name2);
        return nResult;
    }

    private void swap(int i, int j) {
        Object tempObj = null;
        tempObj = this.m_items[i];
        this.m_items[i] = this.m_items[j];
        this.m_items[j] = tempObj;
    }
}

